document.addEventListener("DOMContentLoaded", function() {
    const noteInput = document.getElementById("noteInput");
    const addNoteBtn = document.getElementById("addNoteBtn");
    const noteList = document.getElementById("noteList");

    addNoteBtn.addEventListener("click", addNote);

    function addNote() {
        const noteText = noteInput.value.trim();
        if (noteText !== "") {
            const currentDate = new Date();
            const dateTime = currentDate.toLocaleString();
            const listItem = createListItem(noteText, dateTime);
            noteList.appendChild(listItem);
            noteInput.value = "";
            saveNoteToLocalStorage(noteText, dateTime);
        } else {
            alert("Please enter a note before adding.");
        }
    }

    function createListItem(noteText, dateTime) {
        const listItem = document.createElement("li");

        const noteContent = document.createElement("div");
        noteContent.classList.add("note-content");
        noteContent.textContent = noteText;
        listItem.appendChild(noteContent);

        const noteDateTime = document.createElement("div");
        noteDateTime.classList.add("note-date-time");
        noteDateTime.textContent = dateTime;
        listItem.appendChild(noteDateTime);

        const deleteButton = document.createElement("button");
        deleteButton.innerHTML = '<i class="fas fa-trash-alt"></i>';
        deleteButton.classList.add("delete-button");
        deleteButton.addEventListener("click", function() {
            deleteNote(listItem);
        });

        listItem.appendChild(deleteButton);
        return listItem;
    }

    function saveNoteToLocalStorage(noteText, dateTime) {
        const notes = JSON.parse(localStorage.getItem("notes")) || [];
        notes.push({ text: noteText, datetime: dateTime });
        localStorage.setItem("notes", JSON.stringify(notes));
    }

    function loadNotes() {
        const notes = JSON.parse(localStorage.getItem("notes")) || [];
        noteList.innerHTML = "";
        notes.forEach(function(note) {
            const listItem = createListItem(note.text, note.datetime);
            noteList.appendChild(listItem);
        });
    }

    function deleteNote(listItem) {
        listItem.remove();
        const notes = JSON.parse(localStorage.getItem("notes")) || [];
        const noteText = listItem.querySelector('.note-content').textContent;
        const noteIndex = notes.findIndex(function(note) {
            return note.text === noteText;
        });
        if (noteIndex !== -1) {
            notes.splice(noteIndex, 1);
            localStorage.setItem("notes", JSON.stringify(notes));
        }
    }

    // Load notes from local storage when the page loads
    loadNotes();
});
